"use client"

import React from "react";
import { WorkflowButton } from "./workflow.button";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { useGetAgencies } from "@/hooks/use-get-agencies";

export function WorkflowButtonAdd() {
  const { setWorkflow } = useApplicationWorkflow()
  const { isLoading, error, data } = useGetAgencies()

  return (
    <WorkflowButton
      step="ADD_SERVICE"
      disabled={isLoading || !!error || !data}
      onClick={() => setWorkflow({
        __tag: "ADD_SERVICE"
      })}
      className={(
        "absolute right-6 top-4 grid place-items-center size-10 !rounded-full overflow-visible"
      )}
    />
  )
}

